#ifndef __ETH_INTF_ERROR_H
#define __ETH_INTF_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// Ethernet Interface Task
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_ETH_INTF_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_ETH_INTF_COMMAND_INVALID   ((TLR_RESULT)0xC05D0001L)

//
// MessageId: TLR_E_ETH_INTF_CONFIG_LOCK
//
// MessageText:
//
//  Configuration is locked.
//
#define TLR_E_ETH_INTF_CONFIG_LOCK       ((TLR_RESULT)0xC05D0002L)

//
// MessageId: TLR_E_ETH_INTF_INVALID_PACKET_LENGHT
//
// MessageText:
//
//  Invalid packet length.
//
#define TLR_E_ETH_INTF_INVALID_PACKET_LENGHT ((TLR_RESULT)0xC05D0003L)

//
// MessageId: TLR_E_ETH_INTF_INVALID_MODE
//
// MessageText:
//
//  Invalid mode in request.
//
#define TLR_E_ETH_INTF_INVALID_MODE      ((TLR_RESULT)0xC05D0004L)

//
// MessageId: TLR_E_ETH_INTF_PARAM_AUTO_NEGOTIATION_PORT_0
//
// MessageText:
//
//  Invalid parameter for auto-negotiation port 0.
//
#define TLR_E_ETH_INTF_PARAM_AUTO_NEGOTIATION_PORT_0 ((TLR_RESULT)0xC05D0005L)

//
// MessageId: TLR_E_ETH_INTF_PARAM_AUTO_NEGOTIATION_PORT_1
//
// MessageText:
//
//  Invalid parameter for auto-negotiation port 1.
//
#define TLR_E_ETH_INTF_PARAM_AUTO_NEGOTIATION_PORT_1 ((TLR_RESULT)0xC05D0006L)

//
// MessageId: TLR_E_ETH_INTF_PARAM_DUPLEX_MODE_PORT_0
//
// MessageText:
//
//  Invalid parameter for duplex mode port 0.
//
#define TLR_E_ETH_INTF_PARAM_DUPLEX_MODE_PORT_0 ((TLR_RESULT)0xC05D0007L)

//
// MessageId: TLR_E_ETH_INTF_PARAM_DUPLEX_MODE_PORT_1
//
// MessageText:
//
//  Invalid parameter for duplex mode port 1.
//
#define TLR_E_ETH_INTF_PARAM_DUPLEX_MODE_PORT_1 ((TLR_RESULT)0xC05D0008L)

//
// MessageId: TLR_E_ETH_INTF_PARAM_TRANSMISSION_RATE_PORT_0
//
// MessageText:
//
//  Invalid parameter for transmission rate port 0.
//
#define TLR_E_ETH_INTF_PARAM_TRANSMISSION_RATE_PORT_0 ((TLR_RESULT)0xC05D0009L)

//
// MessageId: TLR_E_ETH_INTF_PARAM_TRANSMISSION_RATE_PORT_1
//
// MessageText:
//
//  Invalid parameter for transmission rate port 1.
//
#define TLR_E_ETH_INTF_PARAM_TRANSMISSION_RATE_PORT_1 ((TLR_RESULT)0xC05D000AL)

//
// MessageId: TLR_E_ETH_INTF_PARAM_AUTO_CROSSOVER_PORT_0
//
// MessageText:
//
//  Invalid parameter for auto cross-over port 0.
//
#define TLR_E_ETH_INTF_PARAM_AUTO_CROSSOVER_PORT_0 ((TLR_RESULT)0xC05D000BL)

//
// MessageId: TLR_E_ETH_INTF_PARAM_AUTO_CROSSOVER_PORT_1
//
// MessageText:
//
//  Invalid parameter for auto cross-over port 1.
//
#define TLR_E_ETH_INTF_PARAM_AUTO_CROSSOVER_PORT_1 ((TLR_RESULT)0xC05D000CL)

//
// MessageId: TLR_E_ETH_INTF_NO_CONFIGURATION
//
// MessageText:
//
//  Task is not configured.
//
#define TLR_E_ETH_INTF_NO_CONFIGURATION  ((TLR_RESULT)0xC05D000DL)

//
// MessageId: TLR_E_ETH_INTF_APP_NOT_REGISTERED
//
// MessageText:
//
//  No application registered.
//
#define TLR_E_ETH_INTF_APP_NOT_REGISTERED ((TLR_RESULT)0xC05D000EL)

//
// MessageId: TLR_E_ETH_INTF_APP_SET_NOT_READY
//
// MessageText:
//
//  Application set not ready.
//
#define TLR_E_ETH_INTF_APP_SET_NOT_READY ((TLR_RESULT)0xC05D000FL)

//
// MessageId: TLR_E_ETH_INTF_LINK_DOWN
//
// MessageText:
//
//  No Ethernet link.
//
#define TLR_E_ETH_INTF_LINK_DOWN         ((TLR_RESULT)0xC05D0010L)

//
// MessageId: TLR_E_ETH_INTF_GET_SEND_BUFFER
//
// MessageText:
//
//  Failed to get send buffer.
//
#define TLR_E_ETH_INTF_GET_SEND_BUFFER   ((TLR_RESULT)0xC05D0011L)

//
// MessageId: TLR_E_ETH_INTF_SEND_FRAME
//
// MessageText:
//
//  Failed to send Ethernet frame.
//
#define TLR_E_ETH_INTF_SEND_FRAME        ((TLR_RESULT)0xC05D0012L)

//
// MessageId: TLR_E_ETH_INTF_SET_DRV_EDD_CFG
//
// MessageText:
//
//  Failed to set driver EDD configuration.
//
#define TLR_E_ETH_INTF_SET_DRV_EDD_CFG   ((TLR_RESULT)0xC05D0013L)

//
// MessageId: TLR_E_ETH_INTF_INVALID_ETH_PORT
//
// MessageText:
//
//  Invalid parameter for ethernet port.
//
#define TLR_E_ETH_INTF_INVALID_ETH_PORT  ((TLR_RESULT)0xC05D0014L)

//
// MessageId: TLR_E_ETH_INTF_UNKNOWN_ERROR
//
// MessageText:
//
//  Unknown error detected.
//
#define TLR_E_ETH_INTF_UNKNOWN_ERROR     ((TLR_RESULT)0xC05DFFFFL)




#endif  //__ETH_INTF_ERROR_H

